package easik.sketch.util.Export.Database;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

/**
 * Class extending JDialog which prompts the user for a username and password, database URL 
 * and name of the database.
 * 
 * @author Vera Ranieri 2006
 * @since 2006-05-11 Vera Ranieri
 * @version 2006-05-12 Vera Ranieri
 */
public class DatabaseUI extends JDialog {
	/**
	 * The window's length
	 */
	private static final int WINDOW_LENGTH = 400;
	/**
	 * The window's height
	 */
	private static final int WINDOW_HEIGHT = 400;
	/**
	 * The window's x-position
	 */
	private static final int WINDOW_POS_X = 300;
	/**
	 * The window's y-position
	 */
	private static final int WINDOW_POS_Y = 250;
	
	/**
	 * The name of the user
	 */
	private String _user;
	/**
	 * The password of the user
	 */
	private String _pass;
	/**
	 * The URL of the database
	 */
	private String _URL;
	/**
	 * The name of the database
	 */
	private String _db;
	/**
	 * The JTextField containing the user name
	 */
	private JTextField _userField;
	/**
	 * The JPasswordField containing the password
	 */
	private JPasswordField _passField;
	/**
	 * The JTextField containing the URL
	 */
	private JTextField _urlField;
	/**
	 * The JTextField containing the name of the database
	 */
	private JTextField _dbField;
	/**
	 * Set to true if the user accepts the inputted information, false otherwise
	 */
	private boolean _accepted;
	/**
	 * The 'ok' button
	 */
	private JButton _ok;
	/**
	 * The 'cancel' button
	 */
	private JButton _cancel;
	/**
	 * A reference to this instance of the DatabaseUI
	 */
	private DatabaseUI _udb = this;
	
	/**
	 * Creates a dialog box prompting the user for input.
	 */
	public DatabaseUI(){
		super();
		this.setSize(WINDOW_LENGTH, WINDOW_HEIGHT);
		this.setResizable(false);
		this.setTitle("Access Database");
		this.setBounds(WINDOW_POS_X, WINDOW_POS_Y, WINDOW_LENGTH, WINDOW_HEIGHT);
		createDialogBox();
		this.setModal(true);
		this.setVisible(true);
	}
	
	/**
	 * Creates a dialog box which prompts the user for a username, password and URL to access the 
	 * desired database.
	 */
	private void createDialogBox(){
		
		JPanel access = new JPanel(new BorderLayout());
		
		//Add the title
		
		JPanel title = new JPanel(new GridLayout(2, 1));
		title.add(new JLabel(""));
		title.add(new JLabel("Input your Username and Password", JLabel.CENTER));
		access.add(title, BorderLayout.NORTH);
		
		//Add the Username text box
		JPanel userPassPane = new JPanel(new GridLayout(11, 1));
		userPassPane.add(new JLabel("UserName"));
		
		_userField = new JTextField();
		userPassPane.add(_userField);
		
		//Add the Password text box
		userPassPane.add(new JLabel("Password"));
		_passField = new JPasswordField();
		userPassPane.add(_passField);
		
		userPassPane.add(new JLabel("Enter the URL of the desired database", JLabel.CENTER));
		//Add the URL text box
		userPassPane.add(new JLabel("URL"));
		_urlField = new JTextField();
		userPassPane.add(_urlField);
		
		//add the name of the database
		userPassPane.add(new JLabel("Enter the name of the database", JLabel.CENTER));
		userPassPane.add(new JLabel("Name"));
		_dbField= new JTextField();
		userPassPane.add(_dbField);
		
		//userPassPane.add(new JLabel("Database Pre-Existing?"));

		access.add(userPassPane, BorderLayout.CENTER);
		
		//Padding to make it look nicer 
		//TODO: better way to do this
		JLabel w = new JLabel("              ");
		access.add(w, BorderLayout.WEST);
		
		JLabel e = new JLabel("              ");
		access.add(e, BorderLayout.EAST);

		//Add the buttons
		_ok = new JButton("OK");
		_ok.setSelected(true);
		//ok.setSelected(true);
		_cancel = new JButton("Cancel");
		
		ButtonActionListener bal = new ButtonActionListener();
		_ok.addActionListener(bal);
		_cancel.addActionListener(bal);
		
		
		JPanel buttons = new JPanel(new GridLayout(1, 2));
		buttons.add(_ok);
		buttons.add(_cancel);
		
		access.add(buttons, BorderLayout.SOUTH);
		access.setVisible(true);
		
		this.getContentPane().add(access);
	}
	
	/**
	 * Gets the username provided by the user.
	 * 
	 * @return The username inputted by the user.
	 */
	public String getUsername() {
		return _user;
	}


	/**
	 * Gets the password provided by the user.
	 * 
	 * @return The password inputted by the user
	 */
	public String getPassword() {
		return _pass;
	}
	
	/**
	 * Returns whether the user selected the accept option from the dialog box.
	 * 
	 * @return true if accpeted, false otherwise
	 */
	public boolean isAccepted(){
		return _accepted;
	}

	/**
	 * Gets the URL of the database, provided by the user.
	 * 
	 * @return The URL of the database platform
	 */
	public String getURL() {
		return _URL;
	}
	
	/**
	 * Returns the name of the database provided by the user.
	 * 
	 * @return The name of the database
	 */
	public String getDb(){
		return _db;
	}

	
	/**
	 * Registers the user's input when the 'ok' or 'cancel' button is pushed.
	 * 
	 * @author Vera Ranieri
	 * @since 2006-05-11 Vera Ranieri
	 * @version 2006-05-16 Vera Ranieri
	 */
	private class ButtonActionListener implements ActionListener{
		/**
		 * called when user presses the 'ok' or 'cancel' button
		 * @param e The action event
		 */
		public void actionPerformed(ActionEvent e){
			if(e.getActionCommand().equals("Cancel")){
				
				_accepted = false;
				_udb.dispose();
				
			}
			else{
				_user = _userField.getText();
				_pass = new String(_passField.getPassword());
				_URL = _urlField.getText();
				_accepted = true;
				_db = _dbField.getText();

				_udb.dispose();
				
			}
		}
	}	
}
